<?php
/*--------------------------------------------------------------------------------------------------
    GroupRepository.php 2020-06-10
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\ProductModifiers\Database\Core;

use Gambio\Shop\Language\ValueObjects\LanguageId;
use Gambio\Shop\ProductModifiers\Database\Core\DTO\Modifiers\ModifierDTO;
use Gambio\Shop\ProductModifiers\Groups\Collections\GroupCollection;
use Gambio\Shop\ProductModifiers\Groups\Collections\GroupCollectionInterface;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;

/**
 * Class GroupRepository
 * @package Gambio\Shop\ProductModifiers\Database\Core
 */
class GroupRepository extends AbstractGroupRepository
{
    /**
     * @inheritDoc
     *
     */
    public function getGroupsByProduct(ProductId $id, LanguageId $languageId): GroupCollectionInterface
    {
        $groups    = $this->groupReaderComposite->getGroupsByProduct($id, $languageId);
        $modifiers = $this->modifierReaderComposite->getModifierByProduct($id, $languageId);
        /**
         * @var ModifierDTO $modifier
         */
        foreach ($modifiers as $modifier) {
            
            $group = $groups->getById($modifier->groupId());
            if ($group) {
                $group->addModifier($modifier);
            }
        }
        
        $result = new GroupCollection();
        foreach ($groups as $group) {
            $result->addGroup($this->groupMapper->mapGroup($group));
        }
        
        return $result;
    }

    /**
     * @param SellingUnitId $id
     * @param LanguageId $languageId
     *
     * @return GroupCollectionInterface
     */
    public function getGroupsBySellingUnit(SellingUnitId $id, LanguageId $languageId): GroupCollectionInterface
    {
        $groups    = $this->groupReaderComposite->getGroupsBySellingUnit($id, $languageId);
        $modifiers = $this->modifierReaderComposite->getModifierBySellingUnit($id, $languageId);
        /**
         * @var ModifierDTO $modifier
         */
        foreach ($modifiers as $modifier) {

            $group = $groups->getById($modifier->groupId());
            if ($group) {
                $group->addModifier($modifier);
            }
        }

        $result = new GroupCollection();
        foreach ($groups as $group) {
            $result->addGroup($this->groupMapper->mapGroup($group));
        }

        return $result;
    }
}